/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: AP_HifPio.h 4490 2020-08-13 13:32:21Z Robert $:

  Description:
    Standardized definitions of RX HIFPIOs

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2010-03-23  File created.

**************************************************************************************/


#ifndef __AP_HIFPIO_H
#define __AP_HIFPIO_H

#ifdef __cplusplus
extern "C" {
#endif

  /*
  ******************************************************************************
  *   Size of one HIFPIO Control Block a Task has to allocate memory for
  ******************************************************************************
  */
  
  #define DRV_HIFPIO_SIZE (72)

 /*
  **************************************************************************
  *   Type declarations
  **************************************************************************
  */
                             
  typedef struct DRV_HIFPIO_DATA_Ttag {
    UINT32 ulData0; 
    UINT32 ulData1; 
  } DRV_HIFPIO_DATA_T;

  /*
  ************************************************************
  *   Function Prototypes
  ************************************************************
  */

  RX_FATAL FAR  DrvHifPioInit               (const FAR void FAR*              ptCfg,
                                             UINT                             uNum);

  RX_RESULT FAR Drv_HifPioCreateHifPio      (RX_HANDLE                        hHifPio, 
                                             const FAR RX_HIFPIO_SET_T FAR*   ptCfg);

  RX_RESULT FAR Drv_HifPioInitializeHifPio  (RX_HANDLE                        hHifPio);

  RX_RESULT FAR Drv_HifPioIdentifyHifPio    (const STRING FAR*                pszIdn,
                                             UINT                             uInst,
                                             RX_HANDLE FAR*                   phHifPio);

  RX_RESULT FAR Drv_HifPioGetInputs         (RX_HANDLE                        hHifPio,
                                             DRV_HIFPIO_DATA_T FAR*           ptData);

  RX_RESULT FAR Drv_HifPioSetOutputs        (RX_HANDLE                        hHifPio, 
                                             DRV_HIFPIO_DATA_T FAR*           ptData);

  RX_RESULT FAR Drv_HifPioGetOutputs        (RX_HANDLE                        hHifPio, 
                                             DRV_HIFPIO_DATA_T FAR*           ptData);
  
#ifdef __cplusplus
}
#endif

#endif
